% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_area_cv.R
\name{lsm_c_area_cv}
\alias{lsm_c_area_cv}
\alias{lsm_c_area_cv.RasterLayer}
\alias{lsm_c_area_cv.RasterStack}
\alias{lsm_c_area_cv.RasterBrick}
\alias{lsm_c_area_cv.list}
\title{AREA_CV (class level)}
\usage{
lsm_c_area_cv(landscape, directions)

\method{lsm_c_area_cv}{RasterLayer}(landscape, directions = 8)

\method{lsm_c_area_cv}{RasterStack}(landscape, directions = 8)

\method{lsm_c_area_cv}{RasterBrick}(landscape, directions = 8)

\method{lsm_c_area_cv}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Coefficient of variation of patch area (Area and edge metric)
}
\details{
\deqn{AREA_{CV} = cv(AREA[patch_{ij}])}
where \eqn{AREA[patch_{ij}]} is the area of each patch in hectares.

AREA_CV is an 'Area and Edge metric'. The metric summarises each class
as the Coefficient of variation of all patch areas belonging to class i.
The metric describes the differences among patches of the same class i in
the landscape and is easily comparable because it is scaled to the mean.

\subsection{Units}{Hectares}
\subsection{Range}{AREA_CV >= 0}
\subsection{Behaviour}{Equals AREA_CV = 0 if all patches are identical in size.
Increases, without limit, as the variation of patch areas increases.}
}
\examples{
lsm_c_area_cv(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{cv}}, \cr
\code{\link{lsm_c_area_mn}},
\code{\link{lsm_c_area_sd}}, \cr
\code{\link{lsm_l_area_mn}},
\code{\link{lsm_l_area_sd}},
\code{\link{lsm_l_area_cv}}
}
