% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{bootVar}
\alias{bootVar}
\title{Bootstrap variance and confidence intervals of indicators on social exclusion
and poverty}
\usage{
bootVar(inc, weights = NULL, years = NULL, breakdown = NULL,
  design = NULL, cluster = NULL, data = NULL, indicator, R = 100,
  bootType = c("calibrate", "naive"), X, totals = NULL, ciType = c("perc",
  "norm", "basic"), alpha = 0.05, seed = NULL, na.rm = FALSE,
  gender = NULL, method = NULL, ...)
}
\arguments{
\item{inc}{either a numeric vector giving the equivalized disposable income,
or (if \code{data} is not \code{NULL}) a character string, an integer or a
logical vector specifying the corresponding column of \code{data}.}

\item{weights}{optional; either a numeric vector giving the personal sample
weights, or (if \code{data} is not \code{NULL}) a character string, an
integer or a logical vector specifying the corresponding column of
\code{data}.}

\item{years}{optional; either a numeric vector giving the different years of
the survey, or (if \code{data} is not \code{NULL}) a character string, an
integer or a logical vector specifying the corresponding column of
\code{data}.  If supplied, values are computed for each year.}

\item{breakdown}{optional; either a numeric vector giving different domains,
or (if \code{data} is not \code{NULL}) a character string, an integer or a
logical vector specifying the corresponding column of \code{data}.  If
supplied, the values for each domain are computed in addition to the overall
value.}

\item{design}{optional; either an integer vector or factor giving different
strata for stratified sampling designs, or (if \code{data} is not
\code{NULL}) a character string, an integer or a logical vector specifying
the corresponding column of \code{data}.  If supplied, this is used as
\code{strata} argument in the call to \code{\link[boot]{boot}}.}

\item{cluster}{optional; either an integer vector or factor giving different
clusters for cluster sampling designs, or (if \code{data} is not
\code{NULL}) a character string, an integer or a logical vector specifying
the corresponding column of \code{data}.}

\item{data}{an optional \code{data.frame}.}

\item{indicator}{an object inheriting from the class \code{"indicator"} that
contains the point estimates of the indicator (see \code{\link{arpr}},
\code{\link{qsr}}, \code{\link{rmpg}} or \code{\link{gini}}).}

\item{R}{a numeric value giving the number of bootstrap replicates.}

\item{bootType}{a character string specifying the type of bootstap to be
performed.  Possible values are \code{"calibrate"} (for calibration of the
sample weights of the resampled observations in every iteration) and
\code{"naive"} (for a naive bootstrap without calibration of the sample
weights).}

\item{X}{if \code{bootType} is \code{"calibrate"}, a matrix of calibration
variables.}

\item{totals}{numeric; if \code{bootType} is \code{"calibrate"}, this gives
the population totals.  If \code{years} is \code{NULL}, a vector should be
supplied, otherwise a matrix in which each row contains the population totals
of the respective year.  If this is \code{NULL} (the default), the population
totals are computed from the sample weights using the Horvitz-Thompson
estimator.}

\item{ciType}{a character string specifying the type of confidence
interval(s) to be computed.  Possible values are \code{"perc"}, \code{"norm"}
and \code{"basic"} (see \code{\link[boot]{boot.ci}}).}

\item{alpha}{a numeric value giving the significance level to be used for
computing the confidence interval(s) (i.e., the confidence level is \eqn{1 -
}\code{alpha}), or \code{NULL}.}

\item{seed}{optional; an integer value to be used as the seed of the random
number generator, or an integer vector containing the state of the random
number generator to be restored.}

\item{na.rm}{a logical indicating whether missing values should be removed.}

\item{gender}{either a numeric vector giving the gender, or (if \code{data}
is not \code{NULL}) a character string, an integer or a logical vector
specifying the corresponding column of \code{data}.}

\item{method}{a character string specifying the method to be used (only for
\code{\link{gpg}}).  Possible values are \code{"mean"} for the mean, and
\code{"median"} for the median.  If weights are provided, the weighted mean
or weighted median is estimated.}

\item{\dots}{if \code{bootType} is \code{"calibrate"}, additional arguments
to be passed to \code{\link{calibWeights}}.}
}
\value{
An object of the same class as \code{indicator} is returned.  See
\code{\link{arpr}}, \code{\link{qsr}}, \code{\link{rmpg}} or
\code{\link{gini}} for details on the components.
}
\description{
Compute variance and confidence interval estimates of indicators on social
exclusion and poverty based on bootstrap resampling.
}
\note{
This function gives reasonable variance estimates for basic sample
designs such as simple random sampling or stratified simple random sampling.
}
\examples{
data(eusilc)
a <- arpr("eqIncome", weights = "rb050", data = eusilc)

## naive bootstrap
bootVar("eqIncome", weights = "rb050", design = "db040",
    data = eusilc, indicator = a, R = 50,
    bootType = "naive", seed = 123)

## bootstrap with calibration
bootVar("eqIncome", weights = "rb050", design = "db040",
    data = eusilc, indicator = a, R = 50,
    X = calibVars(eusilc$db040), seed = 123)
}
\author{
Andreas Alfons
}
\references{
A. Alfons and M. Templ (2013) Estimation of Social Exclusion Indicators
from Complex Surveys: The \R Package \pkg{laeken}.  \emph{Journal of
Statistical Software}, \bold{54}(15), 1--25.  URL
\url{http://www.jstatsoft.org/v54/i15/}
}
\seealso{
\code{\link{variance}}, \code{\link{calibWeights}},
\code{\link{arpr}}, \code{\link{qsr}}, \code{\link{rmpg}}, \code{\link{gini}}
}
\keyword{survey}

