% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/val_labels.R
\name{val_labels}
\alias{val_labels}
\alias{val_labels<-}
\alias{val_label}
\alias{val_label<-}
\alias{set_value_labels}
\alias{add_value_labels}
\alias{remove_value_labels}
\title{Get / Set value labels}
\usage{
val_labels(x, prefixed = FALSE)

val_labels(x) <- value

val_label(x, v, prefixed = FALSE)

val_label(x, v) <- value

set_value_labels(.data, ..., .labels = NA, .strict = TRUE)

add_value_labels(.data, ..., .strict = TRUE)

remove_value_labels(.data, ..., .strict = TRUE)
}
\arguments{
\item{x}{A vector or a data.frame}

\item{prefixed}{Should labels be prefixed with values?}

\item{value}{A named vector for \code{val_labels()} (see \code{\link[haven:labelled]{haven::labelled()}}) or a character string
for \code{val_labels()}. \code{NULL} to remove the labels.
For data frames, it could also be a named list with a vector of value labels per variable.}

\item{v}{A single value.}

\item{.data}{a data frame}

\item{...}{name-value pairs of value labels (see examples)}

\item{.labels}{value labels to be applied to the data.frame,
using the same syntax as \code{value} in \code{val_labels(df) <- value}.}

\item{.strict}{should an error be returned if some labels
doesn't correspond to a column of \code{x}?}
}
\value{
\code{val_labels()} will return a named vector.
\code{val_label()} will return a single character string.

\code{set_value_labels()}, \code{add_value_labels()} and \code{remove_value_labels()} will return an updated
copy of \code{.data}.
}
\description{
Get / Set value labels
}
\note{
\code{set_value_labels()}, \code{add_value_labels()} and \code{remove_value_labels()}
could be used with \pkg{dplyr} syntax.
While \code{set_value_labels()} will replace the list of value labels,
\code{add_value_labels()} and \code{remove_value_labels()} will update that list (see examples).
}
\examples{
v <- labelled(c(1,2,2,2,3,9,1,3,2,NA), c(yes = 1, no = 3, "don't know" = 9))
val_labels(v)
val_labels(v, prefixed = TRUE)
val_label(v, 2)
val_label(v, 2) <- 'maybe'
val_label(v, 9) <- NULL
val_labels(v) <- NULL
if (require(dplyr)) {
  # setting value labels
  df <- tibble(s1 = c("M", "M", "F"), s2 = c(1, 1, 2)) \%>\%
    set_value_labels(s1 = c(Male = "M", Female = "F"), s2 = c(Yes = 1, No = 2))
  val_labels(df)

  # updating value labels
  df <- df \%>\% add_value_labels(s2 = c(Unknown = 9))
  df$s2

  # removing a value labels
  df <- df \%>\% remove_value_labels(s2 = 9)
  df$s2

  # removing all value labels
  df <- df \%>\% set_value_labels(s2 = NULL)
  df$s2
}
}
