% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_labelled.r
\name{to_labelled}
\alias{foreign_to_labelled}
\alias{memisc_to_labelled}
\alias{to_labelled}
\alias{to_labelled.data.frame}
\alias{to_labelled.data.set}
\alias{to_labelled.factor}
\alias{to_labelled.importer}
\alias{to_labelled.list}
\title{Convert to labelled data}
\usage{
to_labelled(x)

\method{to_labelled}{data.frame}(x)

\method{to_labelled}{list}(x)

\method{to_labelled}{data.set}(x)

\method{to_labelled}{importer}(x)

foreign_to_labelled(x)

memisc_to_labelled(x)

\method{to_labelled}{factor}(x)
}
\arguments{
\item{x}{Data to convert to labelled data frame}
}
\value{
a tbl data frame or a labelled vector.
}
\description{
Convert data imported with \pkg{foreign} or \pkg{memisc} to labelled data.
\code{to_labelled} could also be used to convert a factor to a labelled vector.
}
\details{
\code{to_labelled} is a general wrapper calling the appropriate sub-functions.

\code{memisc_to_labelled} converts a \code{\link[memisc]{data.set}} object created with
\pkg{memisc} package to a labelled data frame.

\code{foreign_to_labelled} converts data imported with \code{\link[foreign]{read.spss}}
or \code{\link[foreign]{read.dta}} from \pkg{foreign} package to a labelled data frame,
i.e. using \code{\link{labelled}} class.

Factors will not be converted. Therefore, you should use \code{use.value.labels = FALSE}
when importing with \code{\link[foreign]{read.spss}} or \code{convert.factors = FALSE} when
importing with \code{\link[foreign]{read.dta}}.

To convert correctly defined missing values imported with \code{\link[foreign]{read.spss}}, you should
have used \code{to.data.frame = FALSE} and \code{use.missings = FALSE}. If you used the option
\code{to.data.frame = TRUE}, meta data describing missing values will not be attached to the import.
If you used \code{use.missings = TRUE}, missing values would have been converted to \code{NA}.

So far, missing values defined in Stata are always imported as \code{NA} by
\code{\link[foreign]{read.dta}} and could not be retrieved by \code{foreign_to_labelled}.
}
\examples{
\dontrun{
  # from foreign
  library(foreign)
  df <- to_labelled(read.spss(
    'file.sav',
    to.data.frame = FALSE,
    use.value.labels = FALSE,
    use.missings = FALSE
 ))
 df <- to_labelled(read.dta(
   'file.dta',
   convert.factors = FALSE
 ))

 # from memisc
 library(memisc)
 nes1948.por <- UnZip('anes/NES1948.ZIP', 'NES1948.POR', package='memisc')
 nes1948 <- spss.portable.file(nes1948.por)
 df <- to_labelled(nes1948)
 ds <- as.data.set(nes19480)
 df <- to_labelled(ds)
}

}
\seealso{
\code{\link{labelled}} (\pkg{foreign}), \code{\link[foreign]{read.spss}} (\pkg{foreign}),
  \code{\link[foreign]{read.dta}} (\pkg{foreign}), \code{\link[memisc]{data.set}} (\pkg{memisc}),
  \code{\link[memisc]{importer}} (\pkg{memisc}).
}

