% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_label.R
\name{create_collection_label}
\alias{create_collection_label}
\title{Create collection labels}
\usage{
create_collection_label(
  data = NULL,
  path = NULL,
  filename = NULL,
  qr = NULL,
  field1.column = NULL,
  field2.column = NULL,
  field3.column = NULL,
  field4.column = NULL,
  field5.column = NULL,
  logo = NULL,
  bgcolor = "D0ECC1",
  textcolor = "1E3F20",
  keep.files = FALSE,
  template = NULL
)
}
\arguments{
\item{data}{a data frame. Each row contains the information by species that will appear in the label.}

\item{path}{Character. Path to folder where the PDF file will be saved.}

\item{filename}{Character. Filename of the pdf. If NULL, default is "Collection_label".}

\item{qr}{String. Free text or column of \code{data} that specifies the link for the QR code.
If the specified value of \code{qr} is not a column name of \code{data},
all the QRs will be equal, pointing to the same link.}

\item{field1.column}{Character (optional). Name of the column in \code{data} storing the first free text to
appear at the top of the label.}

\item{field2.column}{Character (optional). Name of the column in \code{data} storing the second free text to
appear below field1.}

\item{field3.column}{Character (optional). Name of the column in \code{data} storing the third free text to
appear below field2.}

\item{field4.column}{Character (optional). Name of the column in \code{data} storing the fourth free text to
appear below field3.}

\item{field5.column}{Character (optional). Name of the column in \code{data} storing the fifth free text to
appear below field4.}

\item{logo}{Character (optional) Path to a PNG image to be located in the label bottom.}

\item{bgcolor}{HTML color for label background. Default is D0ECC1}

\item{textcolor}{HTML color for label text. Default is 1E3F20}

\item{keep.files}{Logical. Keep the RMarkdown template and associated files
in the output folder? Default is FALSE.}

\item{template}{Character (optional) RMarkdown template to use. If not provided,
using the default template included in \code{labeleR}.}
}
\value{
A PDF file named "Collection_label.pdf" is saved on disk, in the folder defined
by \code{path}. If \code{keep.files = TRUE}, an RMarkdown and PNG logo files will also
appear in the same folder.
}
\description{
Create collection labels (8 labels per DIN-A4 page)
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

create_collection_label(
  data = collection.table,
  path = "labeleR_output",
  qr = "QR_code",
  field1.column = "field1",
  field2.column = "field2",
  field3.column = "field3",
  field4.column = "field6",
  field5.column = "field7"
)
\dontshow{\}) # examplesIf}
}
\author{
Ignacio Ramos-Gutierrez, Julia G. de Aledo, Francisco Rodriguez-Sanchez
}
