\name{smooth}
\alias{smooth}

\title{Kolmogorov-Zurbenko Third-Order Periodogram Smoothing Method}

\description{
  Adaptive Smoother for Kolmogorov-Zurbenko Third-Order Periodogram for estimating spectrums
}

\details{
  The Kolmogorov-Zurbenko Third-Order Periodogram is used to estimate spectral density of a signal. The smoothing methods are adaptive allowing the bandwidth of the spectral window to vary according to the smoothness of the underlying spectral density. For details, please see to DiRienzo and Zurbenko (1998) and Neagu and Zurbenko (2003).  
}

\usage{
smooth(p, c=0.01, w=length(p), method="DZ")
}

\arguments{
  \item{p}{The third-order periodogram output from the kztp function.}
  \item{c}{The percentage of variation to be used for smoothing.}
  \item{w}{The half-width of the smoothing window to be used.}
  \item{method}{The smoothing method to apply: currently only DZ is available when p is a matrix, so this can safely be ignored.}
}

\references{
  I. G. Zurbenko, 1986: The spectral Analysis of Time Series. North-Holland, 248 pp.
  
  I. G. Zurbenko, P. S. Porter, Construction of high-resolution wavelets, Signal Processing 65: 315-327, 1998.
  
  W. Yang, I. G. Zurbenko, A semi-adaptive smoothing algorithm in bispectrum estimation, Proceedings of the American Statistical Association, Seattle, 2006.
  
  Wei Yang and Igor Zurbenko, kzft: Kolmogorov-Zurbenko Fourier Transform and Applications, R-Project 2007.
  
}

\seealso{
  \code{\link{kzft}},
  \code{\link{kzp}},
  \code{\link{kztp}},
}

\examples{
#
# example
#
t<-1:10000
y<-sin(2*pi*0.1*t)+3*sin(2*pi*0.2*t) + rnorm(length(t),0,2)

a<-kztp(y,50,1)
z<-log(Mod(a))
s<-smooth(z,0.01,20)

omega<-seq(0,1,length=51)[2:26]
filled.contour(omega,omega,s,xlab="freq",ylab="freq",main="Smoothed 3rd Order Periodogram")

#cleanup
rm(t,y,a,z,s,omega)

}


