% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_freq.analysis.R
\name{freq.analysis}
\alias{freq.analysis}
\alias{freq.analysis,kRp.text-method}
\title{Analyze word frequencies}
\usage{
freq.analysis(txt.file, ...)

\S4method{freq.analysis}{kRp.text}(
  txt.file,
  corp.freq = NULL,
  desc.stat = TRUE,
  corp.rm.class = "nonpunct",
  corp.rm.tag = c()
)
}
\arguments{
\item{txt.file}{An object of class \code{\link[koRpus:kRp.text-class]{kRp.text}}.}

\item{...}{Additional options for the generic.}

\item{corp.freq}{An object of class \code{\link[koRpus:kRp.corp.freq-class]{kRp.corp.freq}}.}

\item{desc.stat}{Logical,
      whether an updated descriptive statistical analysis should be conducted.}

\item{corp.rm.class}{A character vector with word classes which should be ignored for frequency analysis. The default value
\code{"nonpunct"} has special meaning and will cause the result of
\code{kRp.POS.tags(lang, tags=c("punct","sentc"), list.classes=TRUE)} to be used.}

\item{corp.rm.tag}{A character vector with POS tags which should be ignored for frequency analysis.}
}
\value{
An updated object of class \code{\link[koRpus:kRp.text-class]{kRp.text}} with the added feature \code{freq},
   which is a list with information on the word frequencies of the analyzed text.
   Use \code{\link[koRpus:corpusFreq]{corpusFreq}} to get that slot.
}
\description{
The function \code{freq.analysis} analyzes texts regarding frequencies of tokens,
      word classes etc.
}
\details{
It adds new columns with frequency information to the \code{tokens} data frame of the input data,
describing how often the particular token is used in the additionally provided corpus frequency object.

To get the results, you can use \code{taggedText} to get the \code{tokens} slot,
      \code{describe} to get
the raw descriptive statistics (only updated if \code{desc.stat=TRUE}),
      and \code{corpusFreq} to get
the data from the added \code{freq} feature.

If \code{corp.freq} provides appropriate idf values for the types in \code{txt.file}, the
term frequency--inverse document frequency statistic (tf-idf) will also be computed.
Missing idf values will result in \code{NA}.
}
\examples{
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  sample_file <- file.path(
    path.package("koRpus"), "examples", "corpus", "Reality_Winner.txt"
  )
  # call freq.analysis() on a tokenized text
  tokenized.obj <- tokenize(
    txt=sample_file,
    lang="en"
  )
  # the token slot before frequency analysis
  head(taggedText(tokenized.obj))

  # instead of data from a larger corpus, we'll
  # use the token frequencies of the text itself
  tokenized.obj <- freq.analysis(
    tokenized.obj,
    corp.freq=read.corp.custom(tokenized.obj)
  )
  # compare the columns after the anylsis
  head(taggedText(tokenized.obj))

  # the object now has further statistics in a
  # new feature slot called freq
  hasFeature(tokenized.obj)
  corpusFreq(tokenized.obj)
} else {}
}
\seealso{
\code{\link[koRpus:get.kRp.env]{get.kRp.env}},
      \code{\link[koRpus:kRp.text-class]{kRp.text}},
   \code{\link[koRpus:kRp.corp.freq-class]{kRp.corp.freq}}
}
\keyword{misc}
