% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dickes.steiwer.R
\name{dickes.steiwer}
\alias{dickes.steiwer}
\title{Readability: Dickes-Steiwer Handformel}
\usage{
dickes.steiwer(txt.file, parameters = c(const = 235.95993, awl = 73.021, asl =
  12.56438, ttr = 50.03293), case.sens = FALSE, ...)
}
\arguments{
\item{txt.file}{Either an object of class \code{\link[koRpus]{kRp.tagged-class}},
      a character vector which must be be
a valid path to a file containing the text to be analyzed,
      or a list of text features. If the latter, calculation
is done by \code{\link[koRpus:readability.num]{readability.num}}.}

\item{parameters}{A numeric vector with named magic numbers,
      defining the relevant parameters for the index.}

\item{case.sens}{Logical, whether types should be counted case sensitive.}

\item{...}{Further valid options for the main function,
      see \code{\link[koRpus:readability]{readability}} for details.}
}
\value{
An object of class \code{\link[koRpus]{kRp.readability-class}}.
}
\description{
This is just a convenient wrapper function for \code{\link[koRpus:readability]{readability}}.
}
\details{
This function calculates the shortcut formula by Dickes-Steiwer. In contrast to
\code{\link[koRpus:readability]{readability}},
      which by default calculates all possible indices,
this function will only calculate the index value.

This formula doesn't need syllable count.
}
\examples{
\dontrun{
  dickes.steiwer(tagged.text)
}
}
\keyword{readability}
