\name{jumbleWords}
\alias{jumbleWords}
\title{Produce jumbled words}
\usage{
  jumbleWords(words, min.length = 3,
    intact = c(start = 1, end = 1))
}
\arguments{
  \item{words}{Either a character vector or an object
  inheriting from class \code{kRp.tagged}.}

  \item{min.length}{An integer value, defining the minimum
  word length. Words with less characters will not be
  changed.}

  \item{intact}{A named vector with the two integer values
  named \code{start} and \code{stop}.  These define how
  many characters of each relevant words will be left
  unchanged at its start and its end, respectively.}
}
\value{
  Depending on the class of \code{words}, either a
  character vector or tagged text object.
}
\description{
  This function takes either a character vector or objects
  inheriting class \code{kRp.tagged} (i.e., text tokenized
  by \code{koRpus}), and jumbles the words. This usually
  means that the first and last letter of each word is left
  intact, while all characters inbetween are being
  randomized.
}

