% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_random_forest.R
\name{stat.random_forest}
\alias{stat.random_forest}
\title{Importance statistics based on random forests}
\usage{
stat.random_forest(X, X_k, y, ...)
}
\arguments{
\item{X}{n-by-p matrix of original variables.}

\item{X_k}{n-by-p matrix of knockoff variables.}

\item{y}{vector of length n, containing the response variables. If a factor, classification is assumed, 
otherwise regression is assumed.}

\item{...}{additional arguments specific to \code{ranger} (see Details).}
}
\value{
A vector of statistics \eqn{W} of length p.
}
\description{
Computes the difference statistic
  \deqn{W_j = |Z_j| - |\tilde{Z}_j|}
where \eqn{Z_j} and \eqn{\tilde{Z}_j} are the random forest feature importances
of the jth variable and its knockoff, respectively.
}
\details{
This function uses the \code{ranger} package to compute variable 
importance measures. The importance of a variable is measured as the total decrease
in node impurities from splitting on that variable, averaged over all trees. 
For regression, the node impurity is measured by residual sum of squares.
For classification, it is measured by the Gini index.

For a complete list of the available additional arguments, see \code{\link[ranger]{ranger}}.
}
\examples{
p=200; n=100; k=15
mu = rep(0,p); Sigma = diag(p)
X = matrix(rnorm(n*p),n)
nonzero = sample(p, k)
beta = 3.5 * (1:p \%in\% nonzero)
y = X \%*\% beta + rnorm(n)
knockoffs = function(X) create.gaussian(X, mu, Sigma)

# Basic usage with default arguments
result = knockoff.filter(X, y, knockoffs=knockoffs, 
                           statistic=stat.random_forest)
print(result$selected)

# Advanced usage with custom arguments
foo = stat.random_forest
k_stat = function(X, X_k, y) foo(X, X_k, y, nodesize=5)
result = knockoff.filter(X, y, knockoffs=knockoffs, statistic=k_stat)
print(result$selected)

}
\seealso{
Other statistics: 
\code{\link{stat.forward_selection}()},
\code{\link{stat.glmnet_coefdiff}()},
\code{\link{stat.glmnet_lambdadiff}()},
\code{\link{stat.lasso_coefdiff_bin}()},
\code{\link{stat.lasso_coefdiff}()},
\code{\link{stat.lasso_lambdadiff_bin}()},
\code{\link{stat.lasso_lambdadiff}()},
\code{\link{stat.sqrt_lasso}()},
\code{\link{stat.stability_selection}()}
}
\concept{statistics}
