% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_lasso_bin.R
\name{stat.lasso_lambdadiff_bin}
\alias{stat.lasso_lambdadiff_bin}
\title{Importance statistics based on regularized logistic regression}
\usage{
stat.lasso_lambdadiff_bin(X, X_k, y, ...)
}
\arguments{
\item{X}{n-by-p matrix of original variables.}

\item{X_k}{n-by-p matrix of knockoff variables.}

\item{y}{vector of length n, containing the response variables. It should be either a factor with two levels, 
or a two-column matrix of counts or proportions 
(the second column is treated as the target class; for a factor, the last level 
in alphabetical order is the target class). If y is presented as a vector, 
it will be coerced into a factor.}

\item{...}{additional arguments specific to \code{glmnet} (see Details).}
}
\value{
A vector of statistics \eqn{W} of length p.
}
\description{
Fit the lasso path and computes the difference statistic
  \deqn{W_j = Z_j - \tilde{Z}_j}
where \eqn{Z_j} and \eqn{\tilde{Z}_j} are the maximum values of the 
regularization parameter \eqn{\lambda} at which the jth variable 
and its knockoff enter the penalized logistic regression model, respectively.
}
\details{
This function uses \code{glmnet} to compute the lasso path
on a fine grid of \eqn{\lambda}'s.

The \code{nlambda} parameter can be used to control the granularity of the 
grid of \eqn{\lambda}'s. The default value of \code{nlambda} is \code{500}.

This function is a wrapper around the more general \code{\link{stat.glmnet_lambdadiff}}.

For a complete list of the available additional arguments, see \code{\link[glmnet]{glmnet}}
or \code{\link[lars]{lars}}.
}
\examples{
p=200; n=100; k=15
mu = rep(0,p); Sigma = diag(p)
X = matrix(rnorm(n*p),n)
nonzero = sample(p, k)
beta = 3.5 * (1:p \%in\% nonzero)
pr = 1/(1+exp(-X \%*\% beta))
y = rbinom(n,1,pr)
knockoffs = function(X) create.gaussian(X, mu, Sigma)

# Basic usage with default arguments
result = knockoff.filter(X, y, knockoffs=knockoffs, 
                           statistic=stat.lasso_lambdadiff_bin)
print(result$selected)

# Advanced usage with custom arguments
foo = stat.lasso_lambdadiff_bin
k_stat = function(X, X_k, y) foo(X, X_k, y, nlambda=200)
result = knockoff.filter(X, y, knockoffs=knockoffs, statistic=k_stat)
print(result$selected)

}
\seealso{
Other statistics: \code{\link{stat.forward_selection}},
  \code{\link{stat.glmnet_coefdiff}},
  \code{\link{stat.glmnet_lambdadiff}},
  \code{\link{stat.lasso_coefdiff_bin}},
  \code{\link{stat.lasso_coefdiff}},
  \code{\link{stat.lasso_lambdadiff}},
  \code{\link{stat.random_forest}},
  \code{\link{stat.sqrt_lasso}},
  \code{\link{stat.stability_selection}}
}
