library(testit)

op = options(device = function(file = NULL, ...) {
  pdf(file, ...)
  dev.control('enable')  # important! otherwise plots get discarded
})

list_class = function(x) sapply(x, class)

# remove the blank plot
res = evaluate('layout(t(1:2))')
assert(
  'blank plots are removed',
  identical(list_class(res), 'source')
)

assert(
  'plots generated by par(), palette() or layout() are removed',
{
  res = evaluate('par(mfrow = c(1, 2))\npie(islands)\nbarplot(islands)')
  identical(list_class(res), rep(c('source', 'recordedplot'), c(3, 1)))
},
{
  res = evaluate('layout(t(1:2))\npie(islands)\nbarplot(islands)')
  identical(list_class(res), rep(c('source', 'recordedplot'), c(3, 1)))
},
{
  res = evaluate('pie(islands)\nbarplot(islands)\npar(mfrow = c(1, 2))')
  res = merge_low_plot(res)
  identical(list_class(res), rep(c('source', 'recordedplot'), length = 5))
},
{
  res = evaluate('pie(islands)\npar(cex.main=1.2)\nbarplot(islands)')
  res = merge_low_plot(res)
  identical(list_class(res), c('source', 'recordedplot')[c(1, 2, 1, 1, 2)])
},
{
  res = evaluate('par(cex.main=1.2)\npalette(c("red","black"))\nbarplot(islands)')
  identical(list_class(res), rep(c('source', 'recordedplot'), c(3, 1)))
}
)

res = evaluate('plot(1)\npoints(1.1, 1.1)')
assert(
  'merge low-level changes',
  identical(list_class(res), rep(c('source', 'recordedplot'), 2)),
  identical(list_class(merge_low_plot(res)), rep(c('source', 'recordedplot'), c(2, 1)))
)

res = evaluate('library(grid)
    grid.newpage()
    grid.rect(gp=gpar(fill="grey"))
    grid.rect(gp=gpar(fill="red"))')
assert(
  'captures grid graphics',
{
  identical(list_class(res), c('source', 'recordedplot')[c(1, 1, 1, 2, 1, 2)])
},
{
  res = merge_low_plot(res)
  identical(list_class(res), rep(c('source', 'recordedplot'), c(4, 1)))
}
)

options(op); rm(op); rm(res)
rm(list_class)
