% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-conversion.R
\name{knit2pdf}
\alias{knit2pdf}
\title{Convert Rnw or Rrst files to PDF}
\usage{
knit2pdf(input, output = NULL, compiler = NULL, envir = parent.frame(), quiet = FALSE, 
    encoding = getOption("encoding"), ...)
}
\arguments{
\item{input}{Path to the input file.}

\item{output}{Path to the output file for \code{knit()}. If \code{NULL}, this
function will try to guess a default, which will be under the current working
directory.}

\item{compiler}{A character string giving the LaTeX engine used to
compile the tex document to PDF. For an Rrst file, setting \code{compiler} to
\code{'rst2pdf'} will use \code{\link{rst2pdf}} to compile the rst file to
PDF using the ReportLab open-source library.}

\item{envir}{Environment in which code chunks are to be evaluated,
for example, \code{\link{parent.frame}()}, \code{\link{new.env}()}, or
\code{\link{globalenv}()}).}

\item{quiet}{Boolean; suppress the progress bar and messages?}

\item{encoding}{Encoding of the input file; see \code{\link{file}}.}

\item{...}{Options to be passed to \code{tinytex::\link[tinytex]{latexmk}} or
\code{\link{rst2pdf}}.}
}
\value{
The filename of the PDF file.
}
\description{
Knit the input Rnw or Rrst document, and compile to PDF using
\code{tinytex::\link[tinytex]{latexmk}()} or \code{\link{rst2pdf}()}.
}
\note{
The \code{output} argument specifies the output filename to be passed
  to the PDF compiler (e.g. a tex document) instead of the PDF filename.
}
\examples{
#' compile with xelatex
## knit2pdf(..., compiler = 'xelatex')

#' compile a reST file with rst2pdf
## knit2pdf(..., compiler = 'rst2pdf')
}
\author{
Ramnath Vaidyanathan, Alex Zvoleff and Yihui Xie
}
