% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hent_data.R
\name{GetKlass}
\alias{GetKlass}
\title{Fetch classification data
Fetch Statistics Norway classification data using API}
\usage{
GetKlass(
  klass,
  date = NULL,
  correspond = NULL,
  variant = NULL,
  output_level = NULL,
  language = "nb",
  output_style = "normal",
  notes = FALSE
)
}
\arguments{
\item{klass}{Number/string of the classification ID/number. (use Klass_list() to find this)}

\item{date}{String for the required date of the classification. Format must be "yyyy-mm-dd". For an inverval, provide two dates as a vector. If blank, will default to today's date.}

\item{correspond}{Number/string of the target correspondence (if a correspondence table is requested).}

\item{variant}{The classification variant to fetch (if a variant is wanted).}

\item{output_level}{Number/string specifying the requested hierarchy level (optional).}

\item{language}{Two letter string for the requested language output. Default is Bokmål ("nb"). Nynorsk ("nn") and English ("en") also available for some classification.)}

\item{output_style}{String variable for the output type. Default is "normal". Specify "wide" for a wide formatted table output.}

\item{notes}{Logical for if notes should be returned as a column}
}
\value{
The function returns a data frame of the specified classification/correspondence table. Output variables include:
code, parentCode, level, and name for standard lists. For correspondence tables variables include:
sourceCode, sourceName, targetCode and targetName. For time correspondence tables variables include:
oldCode, oldName, newCode and newName. For "wide" output, code and name with level suffixes is specified.
}
\description{
Fetch classification data
Fetch Statistics Norway classification data using API
}
\examples{
# Get classification for occupation classifications
head(GetKlass(klass = "7"))
# Get classification for occupation classifications in English
head(GetKlass(klass = "7", language = "en"))
}
