% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kissmigDummyS.R
\name{kissmigDummyS}
\alias{kissmigDummyS}
\title{Get suitability maps of Europe}
\usage{
kissmigDummyS(mean, sd, download=FALSE)
}
\arguments{
\item{mean}{temperature mean (degree celsius) of the suitability distribution}

\item{sd}{temperature standard deviation (degree celsius) of the  suitability distribution}

\item{download}{if TRUE, required climate data are downloaded from www.worldclim.org}
}
\description{
\command{kissmigDummyS} is a support function to generate suitability maps of Europe for example code.
}
\details{
\command{kissmigDummyS} returns a suitability map of Europe based on mean annual temperature. It uses
data of worldclim and calculates suitability as a normal distribution defined by \command{mean} and \command{sd}
of mean annual temperature. The density function is linarely rescaled to a maximum of 1, the maximum suitability
used in \command{kissmig}. Set \command{download=TRUE} to download the required climate data when running the
function the first time.
}
\references{
\url{https://www.worldclim.org/}
}
\seealso{
\code{\link{kissmig}}
}
