% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{set_trading_env}
\alias{set_trading_env}
\title{Set KIS account number, account product code, app key and app secret}
\usage{
set_trading_env(cano, acnt_prdt_cd, app_key, app_secret, is_paper = FALSE)
}
\arguments{
\item{cano}{A string specifying KIS common account number}

\item{acnt_prdt_cd}{A string specifying KIS account product code}

\item{app_key}{A string specifying KIS app key}

\item{app_secret}{A string specifying KIS app secret}

\item{is_paper}{A string specifying paper trading or not, default \code{FALSE}}
}
\value{
No return value, called to set environment variables
}
\description{
Save environment variables for the current session. To set it permanently, \cr
please add the following line to your .Renvrion file: \cr
}
\section{For live trading}{
KIS_CANO="YOUR ACCOUNT NUMBER" (first 8 digits of your account) \cr
KIS_ACNT_PRDT_CD="01" (last 2 digits of your account) \cr
KIS_APP_KEY="YOUR APP KEY" \cr
KIS_APP_SECRET="YOUR APP SECRET"
}

\section{For paper trading}{
KIS_PAPER_CANO="YOUR PAPER ACCOUNT NUMBER" (first 8 digits of your paper account) \cr
KIS_PAPER_ACNT_PRDT_CD="01" (last 2 digits of your paper account) \cr
KIS_PAPER_APP_KEY="YOUR PAPER APP KEY" \cr
KIS_PAPER_APP_SECRET="YOUR PAPER APP SECRET"
}

\examples{
## Set app key for the current session
\dontrun{
## Set trading environment only for the current session
set_trading_env(
  cano = "your account number",
  acnt_prdt_no = "your account product code",
  app_key = "your app key",
  app_secret = "your app secret"
)
## Check environment variables
print_cano()
print_acnt_prdt_cd()
print_app_key()
print_app_secret()}

}
