% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_image_filenames.R
\name{get_image_filenames_df}
\alias{get_image_filenames_df}
\alias{get_image_filenames_matrix}
\alias{get_image_filenames_list}
\alias{get_image_filenames_list_by_visit}
\alias{get_image_filenames_list_by_subject}
\title{Get Image Filenames in a data.frame}
\usage{
get_image_filenames_df(ids = get_ids(), modalities = all_modalities(),
  visits = c(1, 2), long = TRUE, warn = TRUE, outdir = NULL)

get_image_filenames_matrix(...)

get_image_filenames_list(...)

get_image_filenames_list_by_visit(...)

get_image_filenames_list_by_subject(...)
}
\arguments{
\item{ids}{ID to return}

\item{modalities}{vector of image modalities within
\code{c("FLAIR", "MPRAGE", "T2w", "fMRI", "DTI")} to return}

\item{visits}{Vector of scan indices to return (1 or 2 or both)}

\item{long}{if \code{TRUE}, each row is a subject, visit, modality pair}

\item{warn}{if \code{TRUE}, warnings will be produced when packages
are not installed}

\item{outdir}{output directory for files to download.  It will
default to the directory of the corresponding package for the data.}

\item{...}{arguments passed to \code{\link{get_image_filenames_df}}}
}
\value{
Data.frame of filenames
}
\description{
Return a data.frame of filenames for the images
}
\examples{
get_image_filenames_df()
get_image_filenames_matrix()  
get_image_filenames_list()   
get_image_filenames_list_by_visit()    
get_image_filenames_list_by_subject()     
}
