% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_imp.R
\name{kindling-varimp}
\alias{kindling-varimp}
\alias{garson.ffnn_fit}
\alias{olden.ffnn_fit}
\alias{vi_model.ffnn_fit}
\title{Variable Importance Methods for kindling Models}
\usage{
\method{garson}{ffnn_fit}(mod_in, bar_plot = FALSE, ...)

\method{olden}{ffnn_fit}(mod_in, bar_plot = TRUE, ...)

\method{vi_model}{ffnn_fit}(object, type = c("olden", "garson"), ...)
}
\arguments{
\item{mod_in}{A fitted model object of class "ffnn_fit".}

\item{bar_plot}{Logical. Whether to plot variable importance (default TRUE).}

\item{...}{Additional arguments passed to methods.}

\item{object}{A fitted model object of class "ffnn_fit".}

\item{type}{Type of algorithm to extract the variable importance.
This must be one of the strings:
\itemize{
\item 'olden'
\item 'garson'
}}
}
\value{
A data frame for both "garson" and "olden" classes with columns:
\item{x_names}{Character vector of predictor variable names}
\item{y_names}{Character string of response variable name}
\item{rel_imp}{Numeric vector of relative importance scores (percentage)}
The data frame is sorted by importance in descending order.

A tibble with columns "Variable" and "Importance"
(via \code{vip::vi()} / \code{vip::vi_model()} only).
}
\description{
This file implements methods for variable importance generics from
NeuralNetTools and vip packages.
}
\section{Garson's Algorithm for FFNN Models}{

\code{{kindling}} inherits \code{NeuralNetTools::garson} to extract the variable
importance from the fitted \code{ffnn()} model.
}

\section{Olden's Algorithm for FFNN Models}{

\code{{kindling}} inherits \code{NeuralNetTools::olden} to extract the variable
importance from the fitted \code{ffnn()} model.
}

\section{Variable Importance via \code{{vip}} Package}{

You can directly use \code{vip::vi()} and \code{vip::vi_model()} to extract the variable
importance from the fitted \code{ffnn()} model.
}

\examples{
\donttest{
if (torch::torch_is_installed()) {
    model_mlp = ffnn(
        Species ~ .,
        data = iris,
        hidden_neurons = c(64, 32),
        activations = "relu",
        epochs = 100,
        verbose = FALSE,
        cache_weights = TRUE
    )
    
    # Directly use `NeuralNetTools::garson`
    model_mlp |>
        garson()
    
    # Directly use `NeuralNetTools::olden`    
    model_mlp |>
        olden()
} else {
    message("Torch not fully installed — skipping example")
}
}

\donttest{
# kindling also supports `vip::vi()` / `vip::vi_model()`
if (torch::torch_is_installed()) {
    model_mlp = ffnn(
        Species ~ .,
        data = iris,
        hidden_neurons = c(64, 32),
        activations = "relu",
        epochs = 100,
        verbose = FALSE,
        cache_weights = TRUE
    )

    model_mlp |>
        vip::vi(type = 'garson') |>
        vip::vip()
} else {
    message("Torch not fully installed — skipping example")
}
}

}
\references{
Beck, M.W. 2018. NeuralNetTools: Visualization and Analysis Tools for Neural Networks. Journal of Statistical Software. 85(11):1-20.

Garson, G.D. 1991. Interpreting neural network connection weights. Artificial Intelligence Expert. 6(4):46-51.

Goh, A.T.C. 1995. Back-propagation neural networks for modeling complex systems. Artificial Intelligence in Engineering. 9(3):143-151.

Olden, J.D., Jackson, D.A. 2002. Illuminating the 'black-box': a randomization approach for understanding variable contributions in artificial neural networks. Ecological Modelling. 154:135-150.

Olden, J.D., Joy, M.K., Death, R.G. 2004. An accurate comparison of methods for quantifying variable importance in artificial neural networks using simulated data. Ecological Modelling. 178:389-397.
}
