% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KinPairData.R
\name{kin_pair_data}
\alias{kin_pair_data}
\title{Make new KinPairData object}
\usage{
kin_pair_data(data = NULL, kinship = NULL, lifestage = NULL, cycle = NULL)
}
\arguments{
\item{data}{tlb_df. Tibble of kinpair distances}

\item{kinship}{character. - one of PO, FS, HS, AV, HAV, GG, 1C, H1C, GAV, HGAV, 1C1, H1C1, GGG, 2C, H2C & UN.}

\item{lifestage}{character. - one of 'unknown', 'immature' or 'ovipositional', or alternatively a custom
stage that corresponds to a dispersal stage contained in a \code{DispersalModel} object.}

\item{cycle}{non-negative integer of length one or two (here, 1 is equivalent to c(1, 1)). Represents
the number of complete breeding cycles each individual has undergone before the sampling point, where the time between
birth and first reproduction is coded as '0', that between first and second reproduction '1', etc. (default 0). If the first individual
was sampled as a juvenile & the second as an adult of equivalent stage, the vector c(0, 1) would be used.
In most situations, the default will be appropriate}
}
\value{
returns an object of class \code{KinPairData}
}
\description{
Make new KinPairData object
}
\examples{
kin_pair_data()
}
