% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsave_quick.R
\name{ggsave_quick}
\alias{ggsave_quick}
\title{ggsave quick}
\usage{
ggsave_quick(
  name = NULL,
  file_name_extension = "png",
  timestamp = NULL,
  width = 16,
  height = 9
)
}
\arguments{
\item{name}{a character string of the png file name.
By default, if no input is given (\code{name = NULL}),
the file name will begin with "ggplot".
If the desired output file name is "myplot.png",
enter \code{name = "myplot", timestamp = FALSE}}

\item{file_name_extension}{file name extension (default = "png").
If \code{file_name_extension = "svg"}, Package svglite needs to
be installed.}

\item{timestamp}{if \code{timestamp = TRUE}, a timestamp of the
current time will be appended to the file name.
The timestamp will be in the format, jan_01_2021_1300_10_000001,
where "jan_01_2021" would indicate January 01, 2021;
1300 would indicate 13:00 (i.e., 1 PM); and 10_000001 would
indicate 10.000001 seconds after the hour.
By default, \code{timestamp} will be set as TRUE, if no input
is given for the \code{name} argument, and as FALSE, if an input
is given for the \code{name} argument.}

\item{width}{width of the plot to be saved. This argument will be
directly entered as the \code{width} argument for the \code{ggsave}
function within \code{ggplot2} package (default = 16)}

\item{height}{height of the plot to be saved. This argument will be
directly entered as the \code{height} argument for the \code{ggsave}
function within \code{ggplot2} package (default = 9)}
}
\value{
the output will be a .png image file in the working directory.
}
\description{
quickly save the current plot with a timestamp
}
\examples{
\dontrun{
kim::histogram(rep(1:30, 3))
ggsave_quick()
}
}
