% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/akaike_weights.R
\name{akaike_weights}
\alias{akaike_weights}
\title{Akaike Weights}
\usage{
akaike_weights(aic_values = NULL, print_output_explanation = TRUE)
}
\arguments{
\item{aic_values}{a vector of AIC values}

\item{print_output_explanation}{logical. Should an explanation about
how to read the output be printed? (default = TRUE).}
}
\value{
the output will be a data.table showing AIC weights,
their evidence ratio(s), etc.
}
\description{
Compare adequacy of different models by calculating their Akaike weights
and the associated evidence ratio.
}
\details{
Please refer to Wagenmakers & Farrell (2004),
doi:10.3758/BF03206482
}
\examples{
# default reference AIC value is the minimum AIC value, e.g., 202 below.
akaike_weights(c(204, 202, 206, 206, 214))
}
