% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_from_vector.R
\name{remove_from_vector}
\alias{remove_from_vector}
\title{Remove from a vector}
\usage{
remove_from_vector(values = NULL, vector = NULL, silent = FALSE)
}
\arguments{
\item{values}{a single value or a vector of values which will be
removed from the target vector}

\item{vector}{a character or numeric vector}

\item{silent}{if \code{silent = FALSE}, a summary of values removed
will be printed; if \code{silent = TRUE}, such summary will not be
printed. By default, \code{silent = FALSE}}
}
\value{
the output will be a vector with the given values removed.
}
\description{
Remove certain values from a vector
}
\examples{
remove_from_vector(values = 1, vector = 1:3)
remove_from_vector(values = NA, vector = c(1:3, NA))
remove_from_vector(values = c(1, NA), vector = c(1:3, NA))
remove_from_vector(values = 1:5, vector = 1:10)
}
