% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tv.R
\name{tv}
\alias{tv}
\title{Tabulate vector}
\usage{
tv(
  vector = NULL,
  na.rm = TRUE,
  sort_by_decreasing_count = NULL,
  sort_by_increasing_count = NULL,
  sort_by_decreasing_value = NULL,
  sort_by_increasing_value = NULL,
  total_included = TRUE,
  sigfigs = NULL,
  round_digits_after_decimal = NULL,
  output_type = "dt"
)
}
\arguments{
\item{vector}{a character or numeric vector}

\item{na.rm}{if \code{TRUE}, NA values will be removed before calculating
frequencies and proportions.}

\item{sort_by_decreasing_count}{if \code{TRUE}, the output table will
be sorted in the order of decreasing frequency.}

\item{sort_by_increasing_count}{if \code{TRUE}, the output table will
be sorted in the order of increasing frequency.}

\item{sort_by_decreasing_value}{if \code{TRUE}, the output table will
be sorted in the order of decreasing value.}

\item{sort_by_increasing_value}{if \code{TRUE}, the output table will
be sorted in the order of increasing value.}

\item{total_included}{if \code{TRUE}, the output table will include
a row for total counts.}

\item{sigfigs}{number of significant digits to round to}

\item{round_digits_after_decimal}{round to nth digit after decimal
(alternative to \code{sigfigs})}

\item{output_type}{if \code{output_type = "df"}, return a data.frame.
By default, \code{output_type = "dt"}, which will return a data.table.}
}
\value{
if \code{output_type = "dt"}, which is the default, the output
will be a data.table showing the count and proportion (percent) of each
element in the given vector; if \code{output_type = "df"}, the output will
be a data.frame showing the count and proportion (percent) of each value
in the given vector.
}
\description{
Shows frequency and proportion of unique values in a table format.
This function is a copy of the earlier function, tabulate_vector,
in Package 'kim'
}
\examples{
tv(c("a", "b", "b", "c", "c", "c", NA))
tv(c("a", "b", "b", "c", "c", "c", NA),
  sort_by_increasing_count = TRUE
)
tv(c("a", "b", "b", "c", "c", "c", NA),
  sort_by_decreasing_value = TRUE
)
tv(c("a", "b", "b", "c", "c", "c", NA),
  sort_by_increasing_value = TRUE
)
tv(c("a", "b", "b", "c", "c", "c", NA),
  sigfigs = 4
)
tv(c("a", "b", "b", "c", "c", "c", NA),
  round_digits_after_decimal = 1
)
tv(c("a", "b", "b", "c", "c", "c", NA),
  output_type = "df"
)
}
