% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_round_p_value.R
\name{pretty_round_p_value}
\alias{pretty_round_p_value}
\title{Pretty round p-value}
\usage{
pretty_round_p_value(
  p_value_vector = NULL,
  round_digits_after_decimal = 3,
  include_p_equals = FALSE
)
}
\arguments{
\item{p_value_vector}{one number or a numeric vector}

\item{round_digits_after_decimal}{round to nth digit after decimal}

\item{include_p_equals}{if \code{TRUE}, output will be a string of
mathematical expression including "p", e.g., "p < .01"}
}
\description{
Pretty round p-value
}
\examples{
pretty_round_p_value(
  p_value_vector = 0.049,
  round_digits_after_decimal = 2, include_p_equals = FALSE
)
pretty_round_p_value(c(0.0015, 0.0014), include_p_equals = TRUE)
}
