% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediation_analysis.R
\name{mediation_analysis}
\alias{mediation_analysis}
\title{Mediation analysis}
\usage{
mediation_analysis(
  data = NULL,
  iv_name = NULL,
  mediator_name = NULL,
  dv_name = NULL,
  covariates_names = NULL,
  robust_se = TRUE,
  iterations = 1000,
  plot = TRUE,
  output_type = "summary"
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable}

\item{mediator_name}{name of the mediator variable}

\item{dv_name}{name of the dependent variable}

\item{covariates_names}{names of covariates to control for}

\item{robust_se}{if \code{TRUE}, heteroskedasticity-consistent
standard errors will be used.}

\item{iterations}{number of bootstrap samples. The default is set at 1000,
but consider increasing the number of samples to 5000, 10000, or an
even larger number, if slower handling time is not an issue.}

\item{plot}{if \code{TRUE}, a plot of indirect, direct, and
total effects' respective sizes will be printed.}

\item{output_type}{if \code{output_type = summary}, the output will be
a summary of the mediation anaylsis or if \code{output_type = model},
the output will be a mediation model object. The default value
is "summary".}
}
\description{
Conducts a mediation analysis to estimate an independent variable's
indirect effect on dependent variable through the mediator variable
}
\examples{
\donttest{mediation_analysis(data = mtcars, iv_name = "cyl",
mediator_name = "disp", dv_name = "mpg", iterations = 100)}
}
