% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{mreach.degree}
\alias{mreach.degree}
\title{Compute the M-reach Degree Centrality Score in a Netwrok}
\usage{
mreach.degree(adj.matrix, node, M = Inf, binary = TRUE, cmode = "all",
  large = TRUE, geodist.precomp = NULL)
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.}

\item{node}{Integer indicating the column index of the chosen player
in the adjacenncy matrix. If not specified, scores for all nodes will be reported.}

\item{M}{Number indicating the maximum geodistance between two nodes,
above which the two nodes are considered disconnected.
M hence defines the reachable set. The default is \code{Inf}.}

\item{binary}{Logical scalar. If \code{TRUE}, the adjacency matrix is binarized,
and thus M essentially means steps. If \code{FALSE}, the edge values are
considered.}

\item{cmode}{String indicating the type of centrality being evaluated.
\code{"outdegree"}, \code{"indegree"}, and \code{"total"} refer to
indegree, outdegree, and (total) degree respectively. \code{"all"} reports
all the above measures and is the default.}

\item{large}{Logical scalar, whether the computation method for large network is
implemented. If \code{TRUE} (the default), the method implmented in \pkg{igraph} is
used; otherwise the method implemented in \pkg{sna} is used.}

\item{geodist.precomp}{Geodistance precomputed for the graph to be
analyzed (optional).}
}
\value{
A vector indicating the outdegree, indegree, or total-degree
mreach.degree score of the chosen node; or a data frame containing all
the above information.
}
\description{
\code{mreach.degree} computes the size of reachable nodes from a particular node within M steps.
M-reach degree centrality generalizes the \code{\link[sna]{degree}} centrality
by delimiting specific neighborhoods.
}
\details{
The interprtation of the measure in binary and weighted adjacency matrix
are slightly different. In binary networks, the reachable set of nodes is defined by nodes that
are reachable within M steps. In weighted networks, the reachable set
is defined by nodes that are reachable within geodistance M.
}
\examples{
# Create a 5x5 weighted and directed adjacency matrix,
# where edge values represent the strength of tie
W <- matrix(
  c(0,1,3,0,0,
    0,0,0,4,0,
    1,1,0,2,0,
    0,0,0,0,3,
    0,2,0,0,0),
    nrow=5, ncol=5, byrow = TRUE)


# List the 2-reach degree scores for every node where W is binarized
mreach.degree(W,M=2,cmode="all",large=FALSE)

}
\author{
Weihua An \email{weihuaan@indiana.edu}; Yu-Hsin Liu \email{yuhsliu@indiana.edu}
}
\references{
An, Weihua and Yu-Hsin Liu (2016). "keyplayer: An R Package for Locating Key Players in Social Networks."
Working Paper, Indiana Univeristy.\cr

Butts, Carter T. (2014). sna: Tools for Social Network Analysis. R package
version 2.3-2. \url{http://CRAN.R-project.org/package=sna}\cr

Csardi, G and Nepusz, T (2006). "The igraph software package for complex network research."
InterJournal, Complex Systems 1695. \url{http://igraph.org} \cr
}
\seealso{
\code{\link[sna]{geodist}};
\code{\link[igraph]{shortest.paths}};
\code{\link{mreach.closeness}};
\code{\link{kpcent}};
\code{\link{kpset}}
}

