% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{group.mreach.closeness}
\alias{group.mreach.closeness}
\title{Compute the Group-level mreach.closeness Centrality Score in a Netwrok}
\usage{
group.mreach.closeness(adj.matrix, nodes, M = Inf, method = "min",
  binary = FALSE, cmode = "total", large = TRUE, geodist.precomp = NULL)
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.}

\item{nodes}{Integer indicating the column index of the chosen player
in the adjacenncy matrix. If there are multiple players,
use \code{c(index1,index2,...)}}

\item{M}{Number indicating the maximum distance between two nodes,
above witch the two nodes are considered disconnected. The default is
\code{Inf}.}

\item{method}{Indication of which grouping criterion should be used.
\code{method="min"} indicates the "minimum" criterion (edge values as distances).
\code{method="max"} indicates the "maximum" criterion (edge values as non-cummulative strengths).
\code{method="add"} indicates the "addition" criterion (edge values as cummulative strengths).
\code{method="union"} indicates the "union" criterion (edge values as probability).
The default is the "minimum" criterion for mrach.closeness centrality.}

\item{binary}{If \code{TRUE}, the adjacency matrix is binarized.
If \code{FALSE}, the edge values are considered.}

\item{cmode}{String indicating the type of centrality being evaluated.
The default is to report the total degree.
\code{"outdegree"} and \code{"indegree"} refer to indegree and outdegree
respectively. If \code{"all"}, all the three types are reported.}

\item{large}{Logical scalar, whether the computation method for large network is
implemented. If \code{TRUE} (the default), the method implmented in \pkg{igraph} is
used; otherwise the method implemented in \pkg{sna} is used.}

\item{geodist.precomp}{Geodistance precomputed for the graph to be
analyzed (optional).}
}
\value{
A vector indicating the outdegree, indegree, or total-degree
cohesion score of the chosen players; or a data frame containing all
the above information. Note that the outdegree and indegree scores are normalized
to [0,1]. This means that the total-degree score is between [0,2].
}
\description{
\code{mreach.closeness} refines the \code{\link{mreach.degree}} centrality by
using the (inverse) geodistance as weights.
The edge values should be properly interpreted as distances.
}
\author{
Weihua An \email{weihuaan@indiana.edu}; Yu-Hsin Liu \email{yuhsliu@indiana.edu}
}
\keyword{internal}

