% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{compare_structure}
\alias{compare_structure}
\title{Compare structure of two data frames}
\usage{
compare_structure(x, y)
}
\arguments{
\item{x}{First data frame.}

\item{y}{Second data frame.}
}
\value{
A structure comparison object.
}
\description{
Compares the structural properties of two data frames without
comparing actual values. Useful for detecting schema drift.
}
\examples{
df1 <- data.frame(id = 1:3, x = c("a", "b", "c"))
df2 <- data.frame(id = 1:5, x = c("a", "b", "c", "d", "e"), y = 1:5)
compare_structure(df1, df2)

}
