% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidths.r
\name{calculate.bandwidths.by.separated.points}
\alias{calculate.bandwidths.by.separated.points}
\title{Calculate temporal bandwidths by separated points}
\usage{
calculate.bandwidths.by.separated.points(
  dataset,
  dependent.variable = "dependent.variable",
  x = "x",
  y = "y",
  time = "year",
  weight = "weight",
  alpha = 0.05,
  margin = 0.1,
  separated.points,
  measure.times,
  temporal.bandwidth.limits,
  temporal.bandwidth.n.levels = 200,
  kernel.function = gaussian.kernel,
  projection = NA,
  include.visualisation = FALSE,
  separated.points.labels,
  round.up.low.variance = FALSE
)
}
\arguments{
\item{dataset}{The dataset to be smoothed as a data.frame.}

\item{dependent.variable}{String name of the column in dataset with the dependent variable (defaults to "dependent.variable"); this column should be numeric or factor.}

\item{x}{String name of column containing numeric x co-ordinate (defaults to "x").}

\item{y}{String name of column containing numeric y co-ordinate (defaults to "y").}

\item{time}{String name of the column in dataset with the time variable (defaults to "year").}

\item{weight}{String name of column in the dataset with numeric weights (defaults to "weight").}

\item{alpha}{Numeric alpha for calculating error margins (defaults to 0.05).}

\item{margin}{Numeric desired error margin for calculating spatial bandwidths (defaults to 0.1).}

\item{separated.points}{Data.frame containing two columns same names as x,y in dataset with x and y coordinates of points to be kept separate.}

\item{measure.times}{A numeric vector of specific times at which to make estimates; if not given, will default to seq(from=min(time),to=max(time),length.out=5).}

\item{temporal.bandwidth.limits}{A numeric vector of length 2 specifying minimum and maximum temporal bandwidth to be tested (defaults to the range of time\emph{0.01 to the range of time}2).}

\item{temporal.bandwidth.n.levels}{Number of distinct levels of temporal bandwidth to be tested (defaults to 200).}

\item{kernel.function}{The kernel function, one of gaussian.kernel, gaussian.square.kernel, triangular.kernel, square.kernel, or a custom function (defaults to gaussian.kernel).}

\item{projection}{A spatial projection as a proj4 string - if given, data will be projected before smoothing and results will be deprojected before returning.}

\item{include.visualisation}{If TRUE, will return a ggplot visualisation.}

\item{separated.points.labels}{String vector of the names of the separated points (used in the visualisation).}

\item{round.up.low.variance}{Set to TRUE if there are periods of time with extremely low variance.}
}
\value{
A list with suggested bandwidth and the choke point and time, plus a visualisation of bandwidths and resolutions if include.visualisation==TRUE.
}
\description{
This function calculates relationships between temporal bandwidth and spatial bandwidths at a series of specified points for a given power and suggests minimum possible temporal bandwidth such that bandwidths at those points are never greater than 2.2365\emph{the distance to the nearest point (for gaussian kernels) or 2}that distance (for other kernels)
}
