% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistic.R
\name{kernelPSI}
\alias{kernelPSI}
\title{computes a valid significance value for the effect of the selected kernels
on the outcome}
\usage{
kernelPSI(
  Y,
  K_select,
  constraints,
  method = "all",
  mu = 0,
  sigma = 1,
  lambda = 1,
  n_replicates = 5000,
  burn_in = 1000
)
}
\arguments{
\item{Y}{the response vector}

\item{K_select}{list of selected kernel}

\item{constraints}{list of quadratic matrices modeling the selection of the
kernels in \code{K_select}}

\item{method}{test statistic. Must be one of the following: \code{ridge} for
log-likelihood ratio for ridge regression, \code{pca} for log-likelihood for
kernel PCA, \code{hsic} for HSIC measures, or \code{all} to obtain
significance values for all three former methods.}

\item{mu}{mean of the response}

\item{sigma}{standard deviation of the response}

\item{lambda}{regularization parameter for ridge regression.}

\item{n_replicates}{number of replicates for the hit-and-run sampler in
\code{\link{sampleH}}}

\item{burn_in}{number of burn_in iteration in \code{\link{sampleH}}}
}
\value{
$p$-values for the chosen methods
}
\description{
In this function, we compute an empirical \eqn{p}-value for the effect of a
subset of kernels on the outcome. A number of statistics are supported in
this function : ridge regression, kernel PCA and the HSIC criterion. The
\eqn{p}-values are determined by comparing the statistic of the original
response vector to those of the replicates. We use the \code{\link{sampleH}}
function to sample replicates of the response in the acceptance region of
the selection event.
}
\details{
For valid inference on hundreds of samples, we recommend setting the number
of replicates to \eqn{50000} and the number of burn-in iterations to
\eqn{10000}. These ranges are to be increased for higher sample sizes.
}
\examples{
n <- 30
p <- 20
K <- replicate(5, matrix(rnorm(n*p), nrow = n, ncol = p), simplify = FALSE)
K <-  sapply(K, function(X) return(X \%*\% t(X) / dim(X)[2]), simplify = FALSE)
Y <- rnorm(n)
L <- Y \%*\% t(Y)
selectK <- FOHSIC(K, L, mKernels = 2)
constraintFO <- forwardQ(K, selectK)
kernelPSI(Y, K[selectK], constraintFO, method = "ridge")

}
