% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{export_savedmodel.keras.src.models.model.Model}
\alias{export_savedmodel.keras.src.models.model.Model}
\title{Export the model as an artifact for inference.}
\usage{
\method{export_savedmodel}{keras.src.models.model.Model}(
  object,
  export_dir_base,
  ...,
  format = "tf_saved_model",
  verbose = TRUE,
  input_signature = NULL
)
}
\arguments{
\item{object}{A keras model.}

\item{export_dir_base}{string, file path where to save
the artifact.}

\item{...}{Additional keyword arguments:
\itemize{
\item Specific to the JAX backend and \code{format="tf_saved_model"}:
\itemize{
\item \code{is_static}: Optional \code{bool}. Indicates whether \code{fn} is
static. Set to \code{FALSE} if \code{fn} involves state updates
(e.g., RNG seeds and counters).
\item \code{jax2tf_kwargs}: Optional \code{dict}. Arguments for
\code{jax2tf.convert}. See the documentation for
\href{https://github.com/jax-ml/jax/blob/main/jax/experimental/jax2tf/README.md}{\code{jax2tf.convert}}.
If \code{native_serialization} and \code{polymorphic_shapes} are
not provided, they will be automatically computed.
}
}}

\item{format}{string. The export format. Supported values:
\code{"tf_saved_model"} and \code{"onnx"}.  Defaults to
\code{"tf_saved_model"}.}

\item{verbose}{whether to print all the variables of the exported model.}

\item{input_signature}{Optional. Specifies the shape and dtype of the
model inputs. Can be a structure of \code{keras.InputSpec},
\code{tf.TensorSpec}, \code{backend.KerasTensor}, or backend tensor. If
not provided, it will be automatically computed. Defaults to
\code{NULL}.}
}
\value{
This is called primarily for the side effect of exporting \code{object}.
The first argument, \code{object} is also returned, invisibly, to enable usage
with the pipe.
}
\description{
(e.g. via TF-Serving).

\strong{Note:} This can currently only be used with
the TensorFlow or JAX backends.

This method lets you export a model to a lightweight SavedModel artifact
that contains the model's forward pass only (its \code{call()} method)
and can be served via e.g. TF-Serving. The forward pass is registered
under the name \code{serve()} (see example below).

The original code of the model (including any custom layers you may
have used) is \emph{no longer} necessary to reload the artifact -- it is
entirely standalone.

\strong{Note:} This feature is currently supported only with TensorFlow, JAX
and Torch backends.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Create the artifact
model |> tensorflow::export_savedmodel("path/to/location")

# Later, in a different process/environment...
library(tensorflow)
reloaded_artifact <- tf$saved_model$load("path/to/location")
predictions <- reloaded_artifact$serve(input_data)

# see tfdeploy::serve_savedmodel() for serving a model over a local web api.
}\if{html}{\out{</div>}}

Here's how to export an ONNX for inference.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Export the model as a ONNX artifact
model |> export_savedmodel("path/to/location", format = "onnx")

# Load the artifact in a different process/environment
onnxruntime <- reticulate::import("onnxruntime")
ort_session <- onnxruntime$InferenceSession("path/to/location")
input_data <- list(....)
names(input_data) <- sapply(ort_session$get_inputs(), `[[`, "name")
predictions <- ort_session$run(NULL, input_data)
}\if{html}{\out{</div>}}
}

\seealso{
Other saving and loading functions: \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{load_model}()} \cr
\code{\link{load_model_weights}()} \cr
\code{\link{register_keras_serializable}()} \cr
\code{\link{save_model}()} \cr
\code{\link{save_model_config}()} \cr
\code{\link{save_model_weights}()} \cr
\code{\link{with_custom_object_scope}()} \cr
}
\concept{saving and loading functions}
