% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback_swap_ema_weights}
\alias{callback_swap_ema_weights}
\title{Swaps model weights and EMA weights before and after evaluation.}
\usage{
callback_swap_ema_weights(swap_on_epoch = FALSE)
}
\arguments{
\item{swap_on_epoch}{Whether to perform swapping at \code{on_epoch_begin()}
and \code{on_epoch_end()}. This is useful if you want to use
EMA weights for other callbacks such as \code{callback_model_checkpoint()}.
Defaults to \code{FALSE}.}
}
\value{
A \code{Callback} instance that can be passed to \code{\link[=fit.keras.src.models.model.Model]{fit.keras.src.models.model.Model()}}.
}
\description{
This callbacks replaces the model's weight values with the values of
the optimizer's EMA weights (the exponential moving average of the past
model weights values, implementing "Polyak averaging") before model
evaluation, and restores the previous weights after evaluation.

The \code{SwapEMAWeights} callback is to be used in conjunction with
an optimizer that sets \code{use_ema = TRUE}.

Note that the weights are swapped in-place in order to save memory.
The behavior is undefined if you modify the EMA weights
or model weights in other callbacks.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Remember to set `use_ema=TRUE` in the optimizer
optimizer <- optimizer_sgd(use_ema = TRUE)
model |> compile(optimizer = optimizer, loss = ..., metrics = ...)

# Metrics will be computed with EMA weights
model |> fit(X_train, Y_train,
             callbacks = c(callback_swap_ema_weights()))

# If you want to save model checkpoint with EMA weights, you can set
# `swap_on_epoch=TRUE` and place ModelCheckpoint after SwapEMAWeights.
model |> fit(
  X_train, Y_train,
  callbacks = c(
    callback_swap_ema_weights(swap_on_epoch = TRUE),
    callback_model_checkpoint(...)
  )
)
}\if{html}{\out{</div>}}
}

\seealso{
Other callbacks: \cr
\code{\link{Callback}()} \cr
\code{\link{callback_backup_and_restore}()} \cr
\code{\link{callback_csv_logger}()} \cr
\code{\link{callback_early_stopping}()} \cr
\code{\link{callback_lambda}()} \cr
\code{\link{callback_learning_rate_scheduler}()} \cr
\code{\link{callback_model_checkpoint}()} \cr
\code{\link{callback_reduce_lr_on_plateau}()} \cr
\code{\link{callback_remote_monitor}()} \cr
\code{\link{callback_tensorboard}()} \cr
\code{\link{callback_terminate_on_nan}()} \cr
}
\concept{callbacks}
