% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-utils.R
\name{split_dataset}
\alias{split_dataset}
\title{Splits a dataset into a left half and a right half (e.g. train / test).}
\usage{
split_dataset(
  dataset,
  left_size = NULL,
  right_size = NULL,
  shuffle = FALSE,
  seed = NULL
)
}
\arguments{
\item{dataset}{A \code{tf$data$Dataset}, a \code{torch$utils$data$Dataset} object,
or a list of arrays with the same length.}

\item{left_size}{If float (in the range \verb{[0, 1]}), it signifies
the fraction of the data to pack in the left dataset. If integer, it
signifies the number of samples to pack in the left dataset. If
\code{NULL}, defaults to the complement to \code{right_size}.
Defaults to \code{NULL}.}

\item{right_size}{If float (in the range \verb{[0, 1]}), it signifies
the fraction of the data to pack in the right dataset.
If integer, it signifies the number of samples to pack
in the right dataset.
If \code{NULL}, defaults to the complement to \code{left_size}.
Defaults to \code{NULL}.}

\item{shuffle}{Boolean, whether to shuffle the data before splitting it.}

\item{seed}{A random seed for shuffling.}
}
\value{
A list of two \code{tf$data$Dataset} objects:
the left and right splits.
}
\description{
Splits a dataset into a left half and a right half (e.g. train / test).
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{data <- random_uniform(c(1000, 4))
c(left_ds, right_ds) \%<-\% split_dataset(list(data$numpy()), left_size = 0.8)
left_ds$cardinality()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(800, shape=(), dtype=int64)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{right_ds$cardinality()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(200, shape=(), dtype=int64)

}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/utils/python_utils#splitdataset-function}
}

Other dataset utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{dataset utils}
\concept{utils}
