% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-utils.R
\name{image_to_array}
\alias{image_to_array}
\title{Converts a PIL Image instance to a matrix.}
\usage{
image_to_array(img, data_format = NULL, dtype = NULL)
}
\arguments{
\item{img}{Input PIL Image instance.}

\item{data_format}{Image data format, can be either \code{"channels_first"} or
\code{"channels_last"}. Defaults to \code{NULL}, in which case the global
setting \code{config_image_data_format()} is used (unless you
changed it, it defaults to \code{"channels_last"}).}

\item{dtype}{Dtype to use. \code{NULL} means the global setting
\code{config_floatx()} is used (unless you changed it, it
defaults to \code{"float32"}).}
}
\value{
A 3D array.
}
\description{
Converts a PIL Image instance to a matrix.
}
\section{Example}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{image_path <- get_file(origin = "https://www.r-project.org/logo/Rlogo.png")
(img <- image_load(image_path))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## <PIL.Image.Image image mode=RGB size=724x561>

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{array <- image_to_array(img)
str(array)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{##  num [1:561, 1:724, 1:3] 0 0 0 0 0 0 0 0 0 0 ...

}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/data_loading/image#imgtoarray-function}
}

Other image utils: \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{op_image_affine_transform}()} \cr
\code{\link{op_image_crop}()} \cr
\code{\link{op_image_extract_patches}()} \cr
\code{\link{op_image_map_coordinates}()} \cr
\code{\link{op_image_pad}()} \cr
\code{\link{op_image_resize}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pack_x_y_sample_weight}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{unpack_x_y_sample_weight}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{image utils}
\concept{utils}
