% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-recurrent.R
\name{layer_lstm}
\alias{layer_lstm}
\title{Long Short-Term Memory unit - Hochreiter 1997.}
\usage{
layer_lstm(
  object,
  units,
  activation = "tanh",
  recurrent_activation = "sigmoid",
  use_bias = TRUE,
  return_sequences = FALSE,
  return_state = FALSE,
  go_backwards = FALSE,
  stateful = FALSE,
  time_major = FALSE,
  unroll = FALSE,
  kernel_initializer = "glorot_uniform",
  recurrent_initializer = "orthogonal",
  bias_initializer = "zeros",
  unit_forget_bias = TRUE,
  kernel_regularizer = NULL,
  recurrent_regularizer = NULL,
  bias_regularizer = NULL,
  activity_regularizer = NULL,
  kernel_constraint = NULL,
  recurrent_constraint = NULL,
  bias_constraint = NULL,
  dropout = 0,
  recurrent_dropout = 0,
  ...
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{units}{Positive integer, dimensionality of the output space.}

\item{activation}{Activation function to use. Default: hyperbolic tangent
(\code{tanh}). If you pass \code{NULL}, no activation is applied
(ie. "linear" activation: \code{a(x) = x}).}

\item{recurrent_activation}{Activation function to use for the recurrent
step.}

\item{use_bias}{Boolean, whether the layer uses a bias vector.}

\item{return_sequences}{Boolean. Whether to return the last output in the
output sequence, or the full sequence.}

\item{return_state}{Boolean (default FALSE). Whether to return the last state
in addition to the output.}

\item{go_backwards}{Boolean (default FALSE). If TRUE, process the input
sequence backwards and return the reversed sequence.}

\item{stateful}{Boolean (default FALSE). If TRUE, the last state for each
sample at index i in a batch will be used as initial state for the sample
of index i in the following batch.}

\item{time_major}{If True, the inputs and outputs will be in shape
\verb{[timesteps, batch, feature]}, whereas in the False case, it will be
\verb{[batch, timesteps, feature]}. Using \code{time_major = TRUE} is a bit more
efficient because it avoids transposes at the beginning and end of the RNN
calculation. However, most TensorFlow data is batch-major, so by default
this function accepts input and emits output in batch-major form.}

\item{unroll}{Boolean (default FALSE). If TRUE, the network will be unrolled,
else a symbolic loop will be used. Unrolling can speed-up a RNN, although
it tends to be more memory-intensive. Unrolling is only suitable for short
sequences.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix, used
for the linear transformation of the inputs.}

\item{recurrent_initializer}{Initializer for the \code{recurrent_kernel} weights
matrix, used for the linear transformation of the recurrent state.}

\item{bias_initializer}{Initializer for the bias vector.}

\item{unit_forget_bias}{Boolean. If TRUE, add 1 to the bias of the forget
gate at initialization. Setting it to true will also force
\code{bias_initializer="zeros"}. This is recommended in \href{https://www.jmlr.org/proceedings/papers/v37/jozefowicz15.pdf}{Jozefowicz et al.}}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel}
weights matrix.}

\item{recurrent_regularizer}{Regularizer function applied to the
\code{recurrent_kernel} weights matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{activity_regularizer}{Regularizer function applied to the output of the
layer (its "activation")..}

\item{kernel_constraint}{Constraint function applied to the \code{kernel} weights
matrix.}

\item{recurrent_constraint}{Constraint function applied to the
\code{recurrent_kernel} weights matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{dropout}{Float between 0 and 1. Fraction of the units to drop for the
linear transformation of the inputs.}

\item{recurrent_dropout}{Float between 0 and 1. Fraction of the units to drop
for the linear transformation of the recurrent state.}

\item{...}{Standard Layer args.}
}
\description{
For a step-by-step description of the algorithm, see \href{https://colah.github.io/posts/2015-08-Understanding-LSTMs/}{this tutorial}.
}
\section{Input shapes}{


N-D tensor with shape \verb{(batch_size, timesteps, ...)},
or \verb{(timesteps, batch_size, ...)} when \code{time_major = TRUE}.
}

\section{Output shape}{

\itemize{
\item if \code{return_state}: a list of tensors. The first tensor is
the output. The remaining tensors are the last states,
each with shape \verb{(batch_size, state_size)}, where \code{state_size}
could be a high dimension tensor shape.
\item if \code{return_sequences}: N-D tensor with shape \verb{[batch_size, timesteps, output_size]}, where \code{output_size} could be a high dimension tensor shape, or
\verb{[timesteps, batch_size, output_size]} when \code{time_major} is \code{TRUE}
\item else, N-D tensor with shape \verb{[batch_size, output_size]}, where
\code{output_size} could be a high dimension tensor shape.
}
}

\section{Masking}{


This layer supports masking for input data with a variable number of
timesteps. To introduce masks to your data, use
\code{\link[=layer_embedding]{layer_embedding()}} with the \code{mask_zero} parameter set to \code{TRUE}.
}

\section{Statefulness in RNNs}{


You can set RNN layers to be 'stateful', which means that the states computed
for the samples in one batch will be reused as initial states for the samples
in the next batch. This assumes a one-to-one mapping between samples in
different successive batches.

For intuition behind statefulness, there is a helpful blog post here:
\url{https://philipperemy.github.io/keras-stateful-lstm/}

To enable statefulness:
\itemize{
\item Specify \code{stateful = TRUE} in the layer constructor.
\item Specify a fixed batch size for your model. For sequential models,
pass \code{batch_input_shape = list(...)} to the first layer in your model.
For functional models with 1 or more Input layers, pass
\code{batch_shape = list(...)} to all the first layers in your model.
This is the expected shape of your inputs \emph{including the batch size}.
It should be a list of integers, e.g. \code{list(32, 10, 100)}.
For dimensions which can vary (are not known ahead of time),
use \code{NULL} in place of an integer, e.g. \code{list(32, NULL, NULL)}.
\item Specify \code{shuffle = FALSE} when calling \code{fit()}.
}

To reset the states of your model, call \code{layer$reset_states()} on either
a specific layer, or on your entire model.
}

\section{Initial State of RNNs}{


You can specify the initial state of RNN layers symbolically by calling them
with the keyword argument \code{initial_state.} The value of initial_state should
be a tensor or list of tensors representing the initial state of the RNN
layer.

You can specify the initial state of RNN layers numerically by calling
\code{reset_states} with the named argument \code{states.} The value of \code{states} should
be an array or list of arrays representing the initial state of the RNN
layer.
}

\section{Passing external constants to RNNs}{


You can pass "external" constants to the cell using the \code{constants} named
argument of \verb{RNN$__call__} (as well as \code{RNN$call}) method. This requires that the
\code{cell$call} method accepts the same keyword argument \code{constants}. Such constants
can be used to condition the cell transformation on additional static inputs
(not changing over time), a.k.a. an attention mechanism.
}

\section{References}{

\itemize{
\item \href{https://www.bioinf.jku.at/publications/older/2604.pdf}{Long short-term memory} (original 1997 paper)
\item \href{https://www.cs.toronto.edu/~graves/preprint.pdf}{Supervised sequence labeling with recurrent neural networks}
\item \href{https://arxiv.org/abs/1512.05287}{A Theoretically Grounded Application of Dropout in Recurrent Neural Networks}
}
}

\seealso{
\itemize{
\item \url{https://www.tensorflow.org/guide/keras/rnn}
}

Other recurrent layers: 
\code{\link{layer_cudnn_gru}()},
\code{\link{layer_cudnn_lstm}()},
\code{\link{layer_gru}()},
\code{\link{layer_rnn}()},
\code{\link{layer_simple_rnn}()}

Other recurrent layers: 
\code{\link{layer_cudnn_gru}()},
\code{\link{layer_cudnn_lstm}()},
\code{\link{layer_gru}()},
\code{\link{layer_rnn}()},
\code{\link{layer_simple_rnn}()}
}
\concept{recurrent layers}
