% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_local_conv2d}
\alias{k_local_conv2d}
\title{Apply 2D conv with un-shared weights.}
\usage{
k_local_conv2d(
  inputs,
  kernel,
  kernel_size,
  strides,
  output_shape,
  data_format = NULL
)
}
\arguments{
\item{inputs}{4D tensor with shape: (batch_size, filters, new_rows,
new_cols) if data_format='channels_first' or 4D tensor with shape:
(batch_size, new_rows, new_cols, filters) if data_format='channels_last'.}

\item{kernel}{the unshared weight for convolution, with shape (output_items,
feature_dim, filters)}

\item{kernel_size}{a list of 2 integers, specifying the width and height of
the 2D convolution window.}

\item{strides}{a list of 2 integers, specifying the strides of the
convolution along the width and height.}

\item{output_shape}{a list with (output_row, output_col)}

\item{data_format}{the data format, channels_first or channels_last}
}
\value{
A 4d tensor with shape: (batch_size, filters, new_rows, new_cols) if
data_format='channels_first' or 4D tensor with shape: (batch_size,
new_rows, new_cols, filters) if data_format='channels_last'.
}
\description{
Apply 2D conv with un-shared weights.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

