% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_binary_crossentropy}
\alias{loss_binary_crossentropy}
\title{Computes the binary crossentropy loss.}
\usage{
loss_binary_crossentropy(
  y_true,
  y_pred,
  from_logits = FALSE,
  label_smoothing = 0
)
}
\arguments{
\item{y_true}{True labels (Tensor)}

\item{y_pred}{Predictions (Tensor of the same shape as \code{y_true})}

\item{from_logits}{Whether \code{y_pred} is expected to be a logits tensor. By default,
we assume that y_pred encodes a probability distribution.}

\item{label_smoothing}{numeric between 0 and 1. If > 0 then smooth the labels.}
}
\description{
Computes the binary crossentropy loss.
}
\seealso{
\code{\link[=loss_mean_squared_error]{loss_mean_squared_error()}}
}
