% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{keras_model}
\alias{keras_model}
\title{Keras Model}
\usage{
keras_model(inputs, outputs = NULL)
}
\arguments{
\item{inputs}{Input layer}

\item{outputs}{Output layer}
}
\description{
A model is a directed acyclic graph of layers.
}
\examples{
\dontrun{
library(keras)

# input layer
inputs <- layer_input(shape = c(784))

# outputs compose input + dense layers
predictions <- inputs \%>\%
  layer_dense(units = 64, activation = 'relu') \%>\% 
  layer_dense(units = 64, activation = 'relu') \%>\% 
  layer_dense(units = 10, activation = 'softmax')

# create and compile model
model <- keras_model(inputs = inputs, outputs = predictions)
model \%>\% compile(
  optimizer = 'rmsprop',
  loss = 'categorical_crossentropy',
  metrics = c('accuracy')
)
}
}
\seealso{
Other model functions: 
\code{\link{compile.keras.engine.training.Model}()},
\code{\link{evaluate.keras.engine.training.Model}()},
\code{\link{evaluate_generator}()},
\code{\link{fit.keras.engine.training.Model}()},
\code{\link{fit_generator}()},
\code{\link{get_config}()},
\code{\link{get_layer}()},
\code{\link{keras_model_sequential}()},
\code{\link{multi_gpu_model}()},
\code{\link{pop_layer}()},
\code{\link{predict.keras.engine.training.Model}()},
\code{\link{predict_generator}()},
\code{\link{predict_on_batch}()},
\code{\link{predict_proba}()},
\code{\link{summary.keras.engine.training.Model}()},
\code{\link{train_on_batch}()}
}
\concept{model functions}
