% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\docType{class}
\name{KerasConstraint}
\alias{KerasConstraint}
\title{Base R6 class for Keras constraints}
\format{An \link{R6Class} generator object}
\description{
Base R6 class for Keras constraints
}
\details{
You can implement a custom constraint either by creating an
R function that accepts a weights (\code{w}) parameter, or by creating
an R6 class that derives from \code{KerasConstraint} and implements a
\code{call} method.
}
\note{
Models which use custom constraints cannot be serialized using
\code{\link[=save_model_hdf5]{save_model_hdf5()}}. Rather, the weights of the model should be saved
and restored using \code{\link[=save_model_weights_hdf5]{save_model_weights_hdf5()}}.
}
\section{Methods}{

\describe{
\item{\code{call(w)}}{Constrain the specified weights.}
}
}

\examples{
\dontrun{
CustomNonNegConstraint <- R6::R6Class(
  "CustomNonNegConstraint",
  inherit = KerasConstraint,
  public = list(
    call = function(x) {
       w * k_cast(k_greater_equal(w, 0), k_floatx())
    }
  )
)

layer_dense(units = 32, input_shape = c(784), 
            kernel_constraint = CustomNonNegConstraint$new())
}

}
\seealso{
\link{constraints}
}
