% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{hdf5_matrix}
\alias{hdf5_matrix}
\title{Representation of HDF5 dataset to be used instead of an R array}
\usage{
hdf5_matrix(datapath, dataset, start = 0, end = NULL,
  normalizer = NULL)
}
\arguments{
\item{datapath}{string, path to a HDF5 file}

\item{dataset}{string, name of the HDF5 dataset in the file specified in datapath}

\item{start}{int, start of desired slice of the specified dataset}

\item{end}{int, end of desired slice of the specified dataset}

\item{normalizer}{function to be called on data when retrieved}
}
\value{
An array-like HDF5 dataset.
}
\description{
Representation of HDF5 dataset to be used instead of an R array
}
\details{
Providing \code{start} and \code{end} allows use of a slice of the dataset.

Optionally, a normalizer function (or lambda) can be given. This will
be called on every slice of data retrieved.
}
