% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_print_tensor}
\alias{k_print_tensor}
\title{Prints \code{message} and the tensor value when evaluated.}
\usage{
k_print_tensor(x, message = "")
}
\arguments{
\item{x}{Tensor to print.}

\item{message}{Message to print jointly with the tensor.}
}
\value{
The same tensor \code{x}, unchanged.
}
\description{
Note that \code{print_tensor} returns a new tensor identical to \code{x} which should
be used in the following code. Otherwise the print operation is not taken
into account during evaluation.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://tensorflow.rstudio.com/reference/keras/index.html#backend}.
}

