% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_in_train_phase}
\alias{k_in_train_phase}
\title{Selects \code{x} in train phase, and \code{alt} otherwise.}
\usage{
k_in_train_phase(x, alt, training = NULL)
}
\arguments{
\item{x}{What to return in train phase (tensor or function that returns a
tensor).}

\item{alt}{What to return otherwise (tensor or function that returns a
tensor).}

\item{training}{Optional scalar tensor (or R logical or integer) specifying
the learning phase.}
}
\value{
Either \code{x} or \code{alt} based on the \code{training} flag. the \code{training}
flag defaults to \code{k_learning_phase()}.
}
\description{
Note that \code{alt} should have the \emph{same shape} as \code{x}.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

