% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_recursive_copy.R
\name{misc_recursive_copy}
\alias{misc_recursive_copy}
\title{misc_recursive_copy}
\usage{
misc_recursive_copy(source_dir, target_dir, force = FALSE)
}
\arguments{
\item{source_dir}{A character string. The path to the directory to be copied.}

\item{target_dir}{A character string. The target path.}

\item{force}{A boolean. If \code{FALSE} (the default) a dialog is prompted to
ask the user if the directories should be copied recursively. If \code{TRUE},
the dialog is not prompted and the \code{source_dir} is copied directly to
\code{target_dir}.}
}
\value{
This function has no return value.
}
\description{
Recursively copying directories and subdirectories.
}
\examples{
if (interactive()) {
  d1 <- file.path(tempdir(), "folder1")
  d2 <- file.path(d1, "folder2")
  d3 <- file.path(tempdir(), "new_folder")
  f1 <- file.path(d1, "file.one")
  dir.create(d2, recursive = TRUE)
  file.create(f1)
  misc_recursive_copy(d1, d3)
}
}
