% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kayadata.R
\docType{package}
\name{kayadata-package}
\alias{kayadata-package}
\title{kayadata package}
\description{
kayadata is a package for working with Kaya identity data for many countries
and regions.

The Kaya identity, named for the economist Yoichi Kaya, who introduced it
(Kaya, 1998); It decomposes the energy-related carbon dioxide emissions from
a nation, region, or the world into the product of four components:
\deqn{F = P \times g \times e \times f,}{F = P * g * e * f}
where \emph{F} is the total emissions, \emph{P} is the population, \emph{g} is the
per-capita GDP, \emph{e} is the energy intensity of the economy, and
\emph{f} is the emissions-intensity of the energy supply.
(Nakicenovic and Swart, 2000,
\href{https://www.ipcc.ch/report/emissions-scenarios/}{Ch. 3, p. 105};
Raupach \emph{et al}, 2007)


The data in this packages covers 1960-2018 for population and GDP, and
1965-2018 for energy and fossil-fuel CO2 emissions.

The package uses data on population and GDP from the World Bank,
using market exchange rates (MER) for GDP because those data go back to
1960. From 1990 onward, Purchasing-Power-Parity (PPP) GDP figures are
available as \code{G_ppp} but using these would require re-calculating
\code{G}, \code{g}, \code{e}, and \code{ef} in the \code{kaya_data}
data frame.

The package uses data on energy consumption and fossil-fuel CO2 emissions
from the
\href{https://www.bp.com/en/global/corporate/energy-economics/statistical-review-of-world-energy.html}{2019 BP Statistical Review of World Energy}
}
\section{License}{


 The \pkg{kayadata} package is open source licensed under the
 MIT License.
}

\section{Bug reports}{

\itemize{
 \item kayadata issue tracker (\url{https://github.com/jonathan-g/kayadata/issues})
}
}

\references{
Kaya, Yoichi and Keiichi Yokobori, _Environment, Energy, and Economy:
Strategies for Sustainability_ (United Nations University Press, 1998).

Nakicenovic, Nebojsa, and Rob Swart (Eds.),
\emph{Special Report on Emissions Scenarios}
(Cambridge University Press, 2000).
\url{https://www.ipcc.ch/report/emissions-scenarios/}

Raupach, Michael R., \emph{et al.}, "Global and regional drivers of accelerating
CO2 emissions," PNAS \strong{104}, 10288--10293 (2007)
\href{https://doi.org/10.1073/pnas.0700609104}{doi: \code{10.1073/pnas.0700609104}}.
}
