% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanji1.R
\name{lookup}
\alias{lookup}
\title{Look up kanji}
\usage{
lookup(kanji, what = c("readmean", "basic", "morphologic"))
}
\arguments{
\item{kanji}{a (vector of) character strings containing kanji.}

\item{what}{the sort of information to display.}
}
\value{
If \code{what} is "readmean" the information is output with cat and there is no return value (invisible NULL)
In the other cases the appropriate subsets of the tables kbase and kmorph are returned
}
\description{
Return readings and meanings or information from \code{kbase} or \code{kmorph}.
}
\details{
This is a very basic interface for a quick lookup information based on exact
knowledge of the kanji (provided by a Japanese input method or its UTF-8 code).
Most of the information is based on the KANJIDIC2 file by EDRDG (see thank you page)
Please use one of the many excellent online kanji dictionaries (see e.g.) more
sophisticated lookup methods and more detailed results.
}
\examples{
lookup(c("\u6674", "\u66c7", "\u96e8"))  
lookup("\u6674\u66c7\u96e8")   # same

}
\author{
Dominic Schuhmacher \email{schuhmacher@math.uni-goettingen.de}
}
