% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway.r
\docType{methods}
\name{get_network_matrix,pathway-method}
\alias{get_network_matrix,pathway-method}
\alias{get_network_matrix}
\title{Function to calculate the network \code{matrix} for a \code{\link{pathway}} object}
\usage{
\S4method{get_network_matrix}{pathway}(object, directed = TRUE)
}
\arguments{
\item{object}{A \code{\link{pathway}} object identifying the pathway for which gene 
interaction infomation should be extracted. Here, KEGG IDs of format
'hsa00100' are used and information is downloaded from the KEGG database.}

\item{directed}{A \code{logic} argument, stating whether the network matrix 
should be returned directed (\code{TRUE}) or undirected (\code{FALSE}).}
}
\value{
The altered \code{\link{pathway}} object, in which the slots \code{'adj'} and 
\code{'sign'} have been changed according to the downloaded information on the 
\code{\link{pathway}}.
}
\description{
This function creates the network matrix representing the gene-gene interaction 
structure within a particular \code{\link{pathway}}. In this process a 
KEGG kgml file is downloaded and saved in the working directory.
}
\author{
Stefanie Friedrichs, Patricia Burger
}
