% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mini_plots.R
\name{spec_boxplot}
\alias{spec_boxplot}
\title{Helper functions to generate inline sparklines}
\usage{
spec_boxplot(
  x,
  width = 200,
  height = 50,
  res = 300,
  add_label = FALSE,
  label_digits = 2,
  same_lim = TRUE,
  lim = NULL,
  xaxt = "n",
  yaxt = "n",
  ann = FALSE,
  col = "lightgray",
  border = NULL,
  boxlty = 0,
  medcol = "red",
  medlwd = 1,
  dir = if (is_latex()) rmd_files_dir() else tempdir(),
  file = NULL,
  file_type = if (is_latex()) "pdf" else "svg",
  ...
)
}
\arguments{
\item{x}{Vector of values or List of vectors of values.}

\item{width}{The width of the plot in pixel}

\item{height}{The height of the plot in pixel}

\item{res}{The resolution of the plot. Default is 300.}

\item{add_label}{For boxplot. T/F to add labels for min, mean and max.}

\item{label_digits}{If T for add_label, rounding digits for the label.
Default is 2.}

\item{same_lim}{T/F. If x is a list of vectors, should all the plots be
plotted in the same range? Default is True.}

\item{lim}{Manually specify plotting range in the form of
\code{c(0, 10)}.}

\item{xaxt}{On/Off for xaxis text}

\item{yaxt}{On/Off for yaxis text}

\item{ann}{On/Off for annotations (titles and axis titles)}

\item{col}{Color for the fill of the histogram bar/boxplot box.}

\item{border}{Color for the border.}

\item{boxlty}{Boxplot - box boarder type}

\item{medcol}{Boxplot - median line color}

\item{medlwd}{Boxplot - median line width}

\item{dir}{Directory of where the images will be saved.}

\item{file}{File name. If not provided, a random name will be used}

\item{file_type}{Graphic device. Can be character (e.g., \code{"pdf"})
or a graphics device function (\code{grDevices::pdf}). This defaults
to \code{"pdf"} if the rendering is in LaTeX and \code{"svg"} otherwise.}

\item{...}{extraparameters passing to boxplot}
}
\description{
These functions helps you quickly generate sets of sparkline
style plots using base R plotting system. Currently, we support histogram,
boxplot, line, scatter and pointrange plots. You can use them together with
\code{column_spec} to generate inline plot in tables. By default, this function
will save images in a folder called "kableExtra" and return the address of
the file.
}
