% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_justification.R
\name{export_justification}
\alias{export_justification}
\title{Export justification as YAML}
\usage{
export_justification(
  x,
  file = NULL,
  encoding = "UTF-8",
  append = TRUE,
  preventOverwriting = TRUE,
  silent = justifier::opts$get("silent")
)
}
\arguments{
\item{x}{The justification, either loaded from one or more files or
programmatically constructed. This can be one or more decisions,
justifications, assertions, or sources.}

\item{file}{If specified, the file to export the justification to.}

\item{encoding}{The encoding to use when writing the file.}

\item{append}{Whether to append to the file, or replace its contents.}

\item{preventOverwriting}{Whether to prevent overwriting an existing file.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
The generated YAML, invisibly, unless file is NULL.
}
\description{
Export justification as YAML
}
\examples{
### Programmatically create a simple justification object
justifierObject <-
  justifier::asrt(
    "assertion",
    source = c(
      justifier::srce('source1'),
      justifier::srce('source2')));

### Export to YAML
justifierYAML <-
  justifier::export_justification(
    justifierObject,
    file=NULL);

### Show YAML
cat(justifierYAML, sep="\n");
}
