% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jubilee-forward-rtn-method.R
\name{jubilee.forward_rtn}
\alias{jubilee.forward_rtn}
\alias{jubilee.backward_rtn}
\title{Internal utility to calculate annualized forward and backward return}
\usage{
jubilee.forward_rtn(fraction, ts, fwd.rtn.duration, tol.frac = 1/12)

jubilee.backward_rtn(fraction, ts, bwd.rtn.duration, tol.frac = 1/12)
}
\arguments{
\item{fraction}{numeric, the ending fraction of regression}

\item{ts}{numeric, the time series data}

\item{fwd.rtn.duration}{numeric, the forward-looking regression period}

\item{tol.frac}{numeric, tolerance of missing data in the beginning, expressed as fraction.
Default is 1/12, that is, one month.}

\item{bwd.rtn.duration}{numeric, the backward-looking regression period}
}
\value{
numeric, the same length as \code{fraction}
}
\description{
Calculate the annualized forward and backward return on the given time series.
The forward return is typically the response variable in a forecast.
The backward return is often used as explanatory variable in a regression.
}
\examples{
\dontrun{
  dtb <- jubilee.repo(online=FALSE)@ie
  dtb$fwd.rtn.10 <- jubilee.forward_rtn(dtb$fraction, dtb$log.tri, 10)
  dtb$bwd.rtn.10 <- jubilee.backward_rtn(dtb$fraction, dtb$log.tri, 10)
  head(subset(dtb, fraction >= 1990),1)$fwd.rtn.10 # 1/1990+10y: 0.16745
  tail(subset(dtb, fraction <= 2000+1/12),1)$bwd.rtn.10 # the same as above
}
}
\author{
Stephen H. Lihn
}
\keyword{utility}
