% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.sb}
\alias{predict.sb}
\alias{predict.sl}
\alias{predict.su}
\title{Predict functions for Johnson Transformation}
\usage{
\method{predict}{sb}(object, newdata, ...)

\method{predict}{su}(object, newdata, ...)

\method{predict}{sl}(object, newdata, ...)
}
\arguments{
\item{object}{a \code{jtrans} object with a specific type}

\item{newdata}{new data to be fitted}

\item{...}{further arguments to match \code{\link{predict}}}
}
\value{
Numeric vector of the transformed values

#'
}
\description{
Generic functions to apply the fitted Johnson transformation to transform new
data.
}
\details{
After the johnson transformation is used, if you want to use the same
transformation on different data, you can use these functions. This is
designed to be the same functionality as the \code{\link{predict}} functions.
}
\examples{
#' # if you want to predict based on a fitted distribution, you must set the
# parameters in the qtls() function using the fitted model object jt.

jt <- jtrans(rexp(300, .4))

# good prediction
predict(jt, rexp(10, .4))

# will generate NaN because newx is from different distribution
predict(jt, rexp(10, .1))
}

